x=xlsread('2015_06_03__23-30-25__Dark Testnighttime.csv');

powerref=x(1,1);%power reference ... divide all ICG power by this and
%subtract from 1 for power coupled into waveguide (eyepiece)

z=x(2:end,[1 4 2 3 19 20]);%rearange the xls columns for icgx, icgy, epex
%epey
z(:,1:4)=z(:,1:4)-ones(77841,1)*x(1,17:20);%subtract off the offsets


y=sortrows(z,[3 4 1 2]);%sort based on the pattern to reshape

numiy=length(find(abs(diff(y(:,3))>0)))+1;%find the number of icg y values
numix=length(find(abs(diff(y(1:size(y,1)/numiy,4))>0)))+1;%find the number of icg x values
numey=length(find(abs(diff(y(1:size(y,1)/numiy/numix,1))>0)))+1;%find the number of epe y values
numex=length(find(abs(diff(y(1:size(y,1)/numiy/numix/numey,2))>0)))+1;%find the number of epe x values

iy=[y(find(abs(diff(y(:,3))>0)),3);y(end,3)];%find the icg y values
ix=[y(find(abs(diff(y(1:size(y,1)/numiy,4))>0)),4);y(size(y,1)/numiy,4)];%find the icg x values
ey=[y(find(abs(diff(y(1:size(y,1)/numiy/numix,1))>0)),1);y(size(y,1)/numiy/numix,1)];%find the epe y values
ex=[y(find(abs(diff(y(1:size(y,1)/numiy/numix/numey,2))>0)),2);y(size(y,1)/numiy/numix/numey,2)];%find the epe x values

ep=reshape(y(:,6),numey,numex,numiy,numix);%resape the epe output into epe paterns, pages based on icg y size, books on icg x size 
ip=reshape(y(:,5),numey,numex,numiy,numix);%resape the icg thruput into epe paterns, pages based on icg y size, books on icg x size 


surf(ex,ey,ep(:,:,1,1))%make a surface plot of the epe output for the first icg y,x point

